/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.exomiser.rest.prioritiser.api;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.monarchinitiative.exomiser.core.genome.GenomeAnalysisService;
import org.monarchinitiative.exomiser.core.model.Gene;
import org.monarchinitiative.exomiser.core.model.GeneIdentifier;
import org.monarchinitiative.exomiser.core.prioritisers.HiPhiveOptions;
import org.monarchinitiative.exomiser.core.prioritisers.Prioritiser;
import org.monarchinitiative.exomiser.core.prioritisers.PriorityFactory;
import org.monarchinitiative.exomiser.core.prioritisers.PriorityResult;
import org.monarchinitiative.exomiser.rest.prioritiser.api.PrioritiserRequest;
import org.monarchinitiative.exomiser.rest.prioritiser.api.PrioritiserResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrioritiserController {
    private static final Logger logger = LoggerFactory.getLogger(PrioritiserController.class);
    private final PriorityFactory priorityFactory;
    private final Map<Integer, GeneIdentifier> geneIdentifiers;

    @Autowired
    public PrioritiserController(PriorityFactory priorityFactory, GenomeAnalysisService hg38GenomeAnalysisService) {
        this.priorityFactory = priorityFactory;
        HashMap<Integer, GeneIdentifier> map = new HashMap<Integer, GeneIdentifier>();
        for (GeneIdentifier geneIdentifier : hg38GenomeAnalysisService.getKnownGeneIdentifiers()) {
            GeneIdentifier previous;
            if (!geneIdentifier.hasEntrezId() || geneIdentifier.getHgncId().isEmpty() || (previous = map.put(geneIdentifier.getEntrezIdAsInteger(), geneIdentifier)) == null) continue;
            logger.warn("Duplicate key added {} - was {}", (Object)geneIdentifier, (Object)previous);
        }
        this.geneIdentifiers = map;
        logger.info("Created GeneIdentifier cache with {} entries", (Object)this.geneIdentifiers.size());
    }

    @GetMapping(value={"about"})
    public String about() {
        return "This service will return a collection of prioritiser results for any given set of:\n\t - HPO identifiers e.g. HPO:00001\n\t - Entrez gene identifiers e.g. 23364\n\t - Specified prioritiser e.g. hiphive along with any prioritiser specific commands e.g. human,mouse,fish,ppi\n\t - limit the number of genes returned e.g. 10";
    }

    @GetMapping(value={""}, produces={"application/json;charset=UTF-8"})
    public PrioritiserResultSet prioritise(@RequestParam(value="phenotypes") List<String> phenotypes, @RequestParam(value="genes", required=false, defaultValue="") List<Integer> genesIds, @RequestParam(value="prioritiser") String prioritiserName, @RequestParam(value="prioritiser-params", required=false, defaultValue="") String prioritiserParams, @RequestParam(value="limit", required=false, defaultValue="0") Integer limit) {
        PrioritiserRequest prioritiserRequest = PrioritiserRequest.builder().prioritiser(prioritiserName).prioritiserParams(prioritiserParams).genes(genesIds).phenotypes(phenotypes).limit(limit.intValue()).build();
        return this.prioritise(prioritiserRequest);
    }

    @PostMapping(value={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public PrioritiserResultSet prioritise(@RequestBody PrioritiserRequest prioritiserRequest) {
        logger.info("{}", (Object)prioritiserRequest);
        Instant start = Instant.now();
        Prioritiser prioritiser = this.parsePrioritiser(prioritiserRequest.getPrioritiser(), prioritiserRequest.getPrioritiserParams());
        List genes = this.makeGenesFromIdentifiers(prioritiserRequest.getGenes());
        List results = this.runLimitAndCollectResults(prioritiser, prioritiserRequest.getPhenotypes(), genes, prioritiserRequest.getLimit());
        Instant end = Instant.now();
        Duration duration = Duration.between(start, end);
        return new PrioritiserResultSet(prioritiserRequest, duration.toMillis(), results);
    }

    private Prioritiser parsePrioritiser(String prioritiserName, String prioritiserParams) {
        switch (prioritiserName) {
            case "phenix": {
                return this.priorityFactory.makePhenixPrioritiser();
            }
            case "phive": {
                return this.priorityFactory.makePhivePrioritiser();
            }
        }
        HiPhiveOptions hiPhiveOptions = HiPhiveOptions.builder().runParams(prioritiserParams).build();
        return this.priorityFactory.makeHiPhivePrioritiser(hiPhiveOptions);
    }

    private List<Gene> makeGenesFromIdentifiers(List<Integer> genesIds) {
        if (genesIds.isEmpty()) {
            logger.info("Gene identifiers not specified - will compare against all known genes.");
            return (List)this.geneIdentifiers.values().parallelStream().map(Gene::new).collect(ImmutableList.toImmutableList());
        }
        return (List)genesIds.stream().map(id -> new Gene(this.geneIdentifiers.getOrDefault(id, this.unrecognisedGeneIdentifier(id)))).collect(ImmutableList.toImmutableList());
    }

    private GeneIdentifier unrecognisedGeneIdentifier(Integer id) {
        return GeneIdentifier.builder().geneSymbol("GENE:" + id).build();
    }

    private List<PriorityResult> runLimitAndCollectResults(Prioritiser prioritiser, List<String> phenotypes, List<Gene> genes, int limit) {
        Stream resultsStream = prioritiser.prioritise(phenotypes, genes).sorted(Comparator.naturalOrder());
        logger.info("Finished {}", (Object)prioritiser.getPriorityType());
        if (limit == 0) {
            return (List)resultsStream.collect(ImmutableList.toImmutableList());
        }
        return (List)resultsStream.limit(limit).collect(ImmutableList.toImmutableList());
    }
}

