/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.exomiser.rest.prioritiser.parsers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.monarchinitiative.exomiser.core.model.GeneIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgncParser {
    private static final Logger logger = LoggerFactory.getLogger(HgncParser.class);
    private final Path hgncTxt;
    private final Map<String, Integer> columnIndex;

    public HgncParser(Path hgncCompleteSetTxtPath) {
        this.hgncTxt = hgncCompleteSetTxtPath;
        this.columnIndex = this.makeColumnIndex(this.hgncTxt);
    }

    public Stream<GeneIdentifier> parseGeneIdentifiers() {
        return this.parseGeneIdentifiers(this.hgncTxt);
    }

    private Map<String, Integer> makeColumnIndex(Path hgncCompleteSetTxtPath) {
        List columnHeaders = this.streamFile(hgncCompleteSetTxtPath).limit(1L).flatMap(line -> Arrays.stream(line.split("\t"))).collect(Collectors.toList());
        return IntStream.range(0, columnHeaders.size()).boxed().collect(Collectors.toMap(i -> (String)columnHeaders.get((int)i), Function.identity()));
    }

    private Stream<String> streamFile(Path path) {
        try {
            return Files.lines(path);
        }
        catch (IOException e) {
            logger.error("Unable to process file {}", (Object)path, (Object)e);
            return Stream.empty();
        }
    }

    private Stream<GeneIdentifier> parseGeneIdentifiers(Path hgncCompleteSetTxtPath) {
        return this.streamFile(hgncCompleteSetTxtPath).skip(1L).map(this.parseGeneIdentifier());
    }

    private Function<String, GeneIdentifier> parseGeneIdentifier() {
        return line -> {
            String[] tokens = line.split("\t");
            if ("Entry Withdrawn".equals(this.getField(tokens, "status"))) {
                return GeneIdentifier.builder().hgncId(this.getField(tokens, "hgnc_id")).geneSymbol(this.getField(tokens, "symbol")).build();
            }
            return GeneIdentifier.builder().geneId(this.getField(tokens, "entrez_id")).geneSymbol(this.getField(tokens, "symbol")).hgncId(this.getField(tokens, "hgnc_id")).hgncSymbol(this.getField(tokens, "name")).entrezId(this.getField(tokens, "entrez_id")).ensemblId(this.getField(tokens, "ensembl_gene_id")).ucscId(this.getField(tokens, "ucsc_id")).build();
        };
    }

    private String getField(String[] tokens, String fieldName) {
        int index = this.columnIndex.getOrDefault(fieldName, 0x7FFFFFFE);
        if (tokens.length < index + 1) {
            return "";
        }
        return tokens[index];
    }
}

